function [f_vec1,g_vec1,time_vec1,theta_vec1] = IBCG (fun_f, grad_f_y,...
    grad_f_x, grad_g_y, grad_g_yx,grad_g_yy,param,theta_0, lambda_0)
disp('IBCG Algorithm starts');
%------------------------parameter definition------------------------------
alpha= param.alpha;
eta= param.eta;
gamma = param.gam;
maxiter = param.maxiter;

x= lambda_0;
y= theta_0;
n = length(x);
m = length(y);

tic;
% --------------------------IBCG algorithm---------------------------------
iter = 0;
f_vec1 = [];
g_vec1 = [];
theta_vec1 = theta_0';
time_vec1 = [];
w = zeros(m,1) ;

while iter <= maxiter
    iter = iter+1;
    w = eta* grad_f_y(y)+ (eye(m,m) -eta*grad_g_yy)*w;
    F = grad_f_x - (grad_g_yx'*w);
   %-----------------------------Find s------------------------------------
    [~,ind] = min(F);
    s = zeros(n,1); s(ind)=1;
   %-----------------------------------------------------------------------
    x = (1-gamma)*x + gamma*s; %update of x 
    y = y - (alpha*grad_g_y(x,y)); % update of y 
    
    cpu_t1 = toc;
    f_vec1 = [f_vec1;fun_f(y)];
    g_vec1 = [g_vec1;norm(grad_g_y(x,y))];
    theta_vec1 = [theta_vec1;y'];
    time_vec1 = [time_vec1;cpu_t1];
    
end

end